package jadean.dean;

import java.util.Collection;

import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;

public abstract class Project {
	private String _projectName;

	public Project(String projectName) {
		this.setProjectName(projectName);
	}

	public void setProjectName(String projectName) {
		this._projectName = projectName;
	}

	public String getProjectName() {
		return this._projectName;
	}

	public abstract Graph<Resource, DefaultEdge> getDependencyGraph(String entryPoint);
	
	public abstract Collection<Resource> getUsedResources(String entryPoint);
	
	public abstract Collection<Resource> getAllResources();
	
	public abstract Collection<Resource> getUnusedResources(String entryPoint);
	
	public abstract void removeResources(Collection<Resource> resources);
}
